<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus;

use Gls\GlsPoland\Soap\Client\Caller\CallerInterface;
use Gls\GlsPoland\Soap\Client\Exception\SoapException;
use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

/**
 * @see https://adeplus.gls-poland.com/adeplus/pm1/manuals/webapi2_pl/chapters/function_list_en.htm
 */
class Client
{
    private $caller;
    private $sandbox;

    public function __construct(CallerInterface $caller, bool $isSandbox)
    {
        $this->caller = $caller;
        $this->sandbox = $isSandbox;
    }

    public function isSandbox(): bool
    {
        return $this->sandbox;
    }

    /**
     * @return ResultInterface|Authorization\Session
     */
    public function logout(Authorization\Logout $parameters): Authorization\Session
    {
        return $this->caller->call('adeLogout', $parameters);
    }

    /**
     * @return ResultInterface|Common\Id
     */
    public function preparingBoxInsert(PreparingBox\Insert $parameters): Common\Id
    {
        return $this->caller->call('adePreparingBox_Insert', $parameters);
    }

    /**
     * @return ResultInterface|Common\Id
     */
    public function preparingBoxDeleteConsignment(PreparingBox\DeleteConsignment $parameters): Common\Id
    {
        return $this->caller->call('adePreparingBox_DeleteConsign', $parameters);
    }

    /**
     * @return ResultInterface|Consignment\Consignment
     */
    public function preparingBoxGetConsignment(PreparingBox\GetConsignment $parameters): Consignment\Consignment
    {
        return $this->caller->call('adePreparingBox_GetConsign', $parameters);
    }

    /**
     * @return ResultInterface|Printout\Labels
     */
    public function preparingBoxGetConsignmentLabels(PreparingBox\GetConsignmentLabels $parameters): Printout\Labels
    {
        return $this->caller->call('adePreparingBox_GetConsignLabels', $parameters);
    }

    /**
     * @return ResultInterface|Printout\LabelsCollection
     */
    public function preparingBoxGetConsignmentLabelsExt(PreparingBox\GetConsignmentLabelsExt $parameters): Printout\LabelsCollection
    {
        return $this->caller->call('adePreparingBox_GetConsignLabelsExt', $parameters);
    }

    /**
     * @return ResultInterface|Common\Id
     */
    public function pickupCreate(Pickup\Create $parameters): Common\Id
    {
        return $this->caller->call('adePickup_Create', $parameters);
    }

    /**
     * @return ResultInterface|Pickup\ConsignmentIdsBindingsCollection
     */
    public function pickupGetConsignmentBindings(Pickup\GetConsignmentBindings $parameters): Pickup\ConsignmentIdsBindingsCollection
    {
        return $this->caller->call('adePickup_GetConsignBinds', $parameters);
    }

    /**
     * @return ResultInterface|Consignment\Consignment
     */
    public function pickupGetConsignment(Pickup\GetConsignment $parameters): Consignment\Consignment
    {
        return $this->caller->call('adePickup_GetConsign', $parameters);
    }

    /**
     * @return ResultInterface|Printout\PickupReceipt
     */
    public function pickupGetReceipt(Pickup\GetReceipt $parameters): Printout\PickupReceipt
    {
        return $this->caller->call('adePickup_GetReceipt', $parameters);
    }

    /**
     * @return ResultInterface|Printout\Labels
     */
    public function pickupGetConsignmentLabels(Pickup\GetConsignmentLabels $parameters): Printout\Labels
    {
        return $this->caller->call('adePickup_GetConsignLabels', $parameters);
    }

    /**
     * @return ResultInterface|Printout\LabelsCollection
     */
    public function pickupGetConsignmentLabelsExt(Pickup\GetConsignmentLabelsExt $parameters): Printout\LabelsCollection
    {
        return $this->caller->call('adePickup_GetConsignLabelsExt', $parameters);
    }

    /**
     * @return ResultInterface|SenderAddress\SenderAddressStatus
     */
    public function senderAddressGetStatus(SenderAddress\GetStatus $parameters): SenderAddress\SenderAddressStatus
    {
        return $this->caller->call('adeSendAddr_GetStatus', $parameters);
    }

    /**
     * @return ResultInterface|SenderAddress\SenderAddressesCollection
     */
    public function senderAddressGetDictionary(SenderAddress\GetDictionary $parameters): SenderAddress\SenderAddressesCollection
    {
        return $this->caller->call('adeSendAddr_GetDictionary', $parameters);
    }

    /**
     * @return ResultInterface|Services\Services
     */
    public function servicesGetAllowed(Services\GetAllowed $parameters): Services\Services
    {
        return $this->caller->call('adeServices_GetAllowed', $parameters);
    }

    /**
     * @return ResultInterface|Services\MaxCODAmount
     */
    public function servicesGetMaxCOD(Services\GetMaxCOD $parameters): Services\MaxCODAmount
    {
        return $this->caller->call('adeServices_GetMaxCOD', $parameters);
    }

    /**
     * @return ResultInterface|Services\MaxParcelWeights
     */
    public function servicesGetMaxParcelWeights(Services\GetMaxParcelWeights $parameters): Services\MaxParcelWeights
    {
        return $this->caller->call('adeServices_GetMaxParcelWeights', $parameters);
    }

    /**
     * @return ResultInterface|Services\Services
     *
     * @throws SoapException
     */
    public function servicesGetGuaranteed(Services\GetGuaranteed $parameters): Services\Services
    {
        return $this->caller->call('adeServices_GetGuaranteed', $parameters);
    }

    /**
     * @return ResultInterface|Common\StringArray
     */
    public function servicesGetCountriesSDS(Services\GetCountriesSDS $parameters): Common\StringArray
    {
        return $this->caller->call('adeServices_GetCountriesSDS', $parameters);
    }

    /**
     * @return ResultInterface|ParcelShop\ParcelShop
     */
    public function parcelShopSearchById(ParcelShop\SearchById $parameters): ParcelShop\ParcelShop
    {
        return $this->caller->call('adeParcelShop_SearchByID', $parameters);
    }
}
