<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\PreparingBox;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;
use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;

final class GetConsignmentLabels extends AuthorizedRequest
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var string
     */
    private $mode;

    public function __construct(int $consignmentId, LabelsPrintMode $printMode)
    {
        $this->id = $consignmentId;
        $this->mode = (string) $printMode;
    }

    public function jsonSerialize(): array
    {
        return [
            'id' => $this->id,
            'mode' => $this->mode,
        ];
    }

    public function getConsignmentId(): int
    {
        return $this->id;
    }

    public function withConsignmentId(int $id): GetConsignmentLabels
    {
        $new = clone $this;
        $new->id = $id;

        return $new;
    }

    public function getPrintMode(): LabelsPrintMode
    {
        return LabelsPrintMode::from($this->mode);
    }

    public function withPrintMode(LabelsPrintMode $printMode): GetConsignmentLabels
    {
        $new = clone $this;
        $new->mode = (string) $printMode;

        return $new;
    }
}
