<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\SenderAddress;

use Gls\GlsPoland\AdePlus\Client as AdePlusClient;

final class Client implements ClientInterface
{
    private $client;

    public function __construct(AdePlusClient $client)
    {
        $this->client = $client;
    }

    public function getStatus(): SenderAddressStatus
    {
        $params = new GetStatus();

        return $this->client->senderAddressGetStatus($params);
    }

    public function getAvailableAddresses(): SenderAddressesCollection
    {
        $params = new GetDictionary();

        return $this->client->senderAddressGetDictionary($params);
    }
}
