<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\SenderAddress;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class SenderAddressesCollection implements ResultInterface, \IteratorAggregate, \JsonSerializable
{
    /**
     * @var SenderAddress[]
     */
    private $items;

    public function __construct(SenderAddress ...$items)
    {
        $this->items = $items;
    }

    /**
     * @return SenderAddress[]
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @return \Iterator<int, SenderAddress>
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->items);
    }

    public function jsonSerialize(): array
    {
        return $this->items;
    }
}
