<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Initializer;

final class ChainInitializer implements ConfigurationInitializerInterface
{
    /**
     * @var iterable<ConfigurationInitializerInterface>
     */
    private $initializers;

    /**
     * @param iterable<ConfigurationInitializerInterface> $initializers
     */
    public function __construct(iterable $initializers)
    {
        $this->initializers = $initializers;
    }

    public function init(): void
    {
        foreach ($this->initializers as $initializer) {
            $initializer->init();
        }
    }
}
