<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Initializer;

use Gls\GlsPoland\Dotenv\Adapter\DotenvLoader;
use Gls\GlsPoland\Dotenv\DotenvLoaderInterface;

final class EnvInitializer implements ConfigurationInitializerInterface
{
    private $module;
    private $dotenvLoader;
    private $env;

    public function __construct(\Module $module, ?DotenvLoaderInterface $dotenvLoader = null, ?string $env = null)
    {
        $this->module = $module;
        $this->dotenvLoader = $dotenvLoader ?? new DotenvLoader();
        $this->env = $env ?? (defined('_PS_MODE_DEV_') && !_PS_MODE_DEV_ ? 'prod' : 'dev');
    }

    public function init(): void
    {
        $path = $this->module->getLocalPath() . '.env';

        $this->dotenvLoader->loadEnv($path, 'GLS_POLAND_ENV', $this->env);
    }
}
