<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Doctrine\ORM\Query;

use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query\Filter\SQLFilter;
use Gls\GlsPoland\Entity\Consignment;

final class SandboxFilter extends SQLFilter
{
    public function addFilterConstraint(ClassMetadata $targetEntity, $targetTableAlias): string
    {
        if (Consignment::class !== $targetEntity->getName()) {
            return '';
        }

        return sprintf('%s.sandbox = %s', $targetTableAlias, $this->getParameter('sandbox'));
    }
}
