<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Labels\Download;

use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;
use Gls\GlsPoland\AdePlus\Printout\PrintoutInterface;
use Gls\GlsPoland\Entity\Consignment;

abstract class AbstractDownloadLabelsHandler implements DownloadLabelsHandlerInterface
{
    /**
     * @var DownloadLabelsHandlerInterface|null
     */
    private $next;

    public function downloadSingle(Consignment $consignment, LabelsPrintMode $printMode): PrintoutInterface
    {
        if (null !== $this->next) {
            return $this->next->downloadSingle($consignment, $printMode);
        }

        throw new \RuntimeException('Could not handle labels download for the given consignment.');
    }

    public function downloadSeparate(Consignment $consignment, LabelsPrintMode $printMode): iterable
    {
        if (null !== $this->next) {
            return $this->next->downloadSeparate($consignment, $printMode);
        }

        throw new \RuntimeException('Could not handle labels download for the given consignment.');
    }

    public function setNext(DownloadLabelsHandlerInterface $handler): DownloadLabelsHandlerInterface
    {
        $this->next = $handler;

        return $handler;
    }
}
