<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout;

use Gls\GlsPoland\Entity\Carrier;
use Gls\GlsPoland\PrestaShop\Asset\DTO\Assets;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

interface CheckoutInterface extends EventSubscriberInterface
{
    public function getAssets(\Cart $cart): Assets;

    public function renderDeliveryOptionsForm(Carrier $carrier, \Cart $cart, int $carrierId): string;

    public function renderMapModal(): string;

    /**
     * @return static
     */
    public function setController(\FrontController $controller): self;
}
