<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Grid\Column;

use PrestaShop\PrestaShop\Core\Grid\Column\AbstractColumn;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @internal
 */
final class ParcelNumbersListColumn extends AbstractColumn
{
    public function getType(): string
    {
        return 'gls_poland_parcel_numbers';
    }

    protected function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver
            ->setRequired(['field'])
            ->setAllowedTypes('field', 'string');
    }
}
