<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Installer;

final class Installer implements InstallerInterface, UninstallerInterface
{
    private $installers;
    private $uninstallers;

    /**
     * @param iterable<InstallerInterface> $installers
     * @param iterable<UninstallerInterface> $uninstallers
     */
    public function __construct(iterable $installers, iterable $uninstallers)
    {
        $this->installers = $installers;
        $this->uninstallers = $uninstallers;
    }

    public function install(\Module $module): void
    {
        foreach ($this->installers as $installer) {
            assert($installer instanceof InstallerInterface);
            $installer->install($module);
        }
    }

    public function uninstall(\Module $module, bool $isReset): void
    {
        foreach ($this->uninstallers as $uninstaller) {
            assert($uninstaller instanceof UninstallerInterface);
            $uninstaller->uninstall($module, $isReset);
        }
    }
}
