<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\ObjectModel;

interface PersistenceInterface
{
    public function save(\ObjectModel $model);

    public function delete(\ObjectModel $model);

    /**
     * Executes a function returning a boolean and throws an exception if the result evaluates to false
     * and the last operation on the underlying database connection was not successful.
     *
     * @param \Closure(): bool $closure
     *
     * @return bool function result
     */
    public function execute(\Closure $closure): bool;
}
